--------------------------------------------------------------------------------
-- MapName: XXX
--
-- Author: XXX
--
--------------------------------------------------------------------------------

-- Include main function
Script.Load( Folders.MapTools.."Main.lua" )
IncludeGlobals("MapEditorTools")
IncludeLocals("player2")
IncludeLocals("KillerWache")
IncludeLocals("GetAngleBetween")
IncludeLocals("TriggerFix")
IncludeLocals("TargetFilter")
IncludeLocals("LuaObject")
IncludeLocals("LeaderFormations")
IncludeLocals("IsValidPosition")
IncludeLocals("IsEntityOfType")
IncludeLocals("GetRandom")
IncludeLocals("GetDistance")
IncludeLocals("GetCirclePosition")
IncludeLocals("FrameworkWrapperLight")
IncludeLocals("EntityIdChangedHelper")
IncludeLocals("CopyTable")
IncludeLocals("army_Bandits")
IncludeLocals("Tower_Bandits")
IncludeLocals("LittlevilleUA")
IncludeLocals("UnlimitedArmy")
IncludeLocals("UnlimitedArmySpawnGenerator")
IncludeLocals("cutscene_control")
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
TriggerFix.AllScriptsLoaded()
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called from main script to initialize the diplomacy states
function InitDiplomacy()
	SetHostile(1,2)
	SetNeutral(1,8)
	SetHostile(2,8)
	SetPlayerName(8, "Grenzdorf Littleville")
	SetPlayerName(1, "Gesandter des Königs, Pilgrim")
    SetPlayerName(2, "Barbaren")
end
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called from main script to init all resources for player(s)
function InitResources()
    -- set some resources
    AddGold  (0)
    AddSulfur(0)
    AddIron  (0)
    AddWood  (0)	
    AddStone (0)	
    AddClay  (0)	
end

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called to setup Technology states on mission start
function InitTechnologies()

    ForbidTechnology(Technologies.UP2_Headquarter)
    ForbidTechnology(Technologies.B_Market)
    ForbidTechnology(Technologies.B_Foundry)
    ForbidTechnology(Technologies.B_Tower)

    ForbidTechnology(Technologies.GT_Architecture)
    ForbidTechnology(Technologies.GT_Library)

    ForbidTechnology(Technologies.GT_Tactics)
    ForbidTechnology(Technologies.GT_Strategies)

    ForbidTechnology(Technologies.GT_Binocular)
    ForbidTechnology(Technologies.GT_Matchlock)
    ForbidTechnology(Technologies.GT_PulledBarrel)

    ForbidTechnology(Technologies.GT_Alloying)
    ForbidTechnology(Technologies.GT_Metallurgy)
    ForbidTechnology(Technologies.GT_Chemistry)

    ForbidTechnology(Technologies.T_UpgradeSword3)
    ForbidTechnology(Technologies.T_UpgradeSpear3)
    ForbidTechnology(Technologies.T_UpgradeBow3)

    ForbidTechnology(Technologies.T_UpgradeSword2)
    ForbidTechnology(Technologies.T_UpgradeSpear2)
    ForbidTechnology(Technologies.T_UpgradeBow2)

end

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called on game start and after save game is loaded, setup your weather gfx
-- sets here
function InitWeatherGfxSets()
    WeatherSets_SetupEvelance(1)
end

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called on game start you should setup your weather periods here
function InitWeather()
	AddPeriodicSummer(1000)
	AddPeriodicRain(240)
end

--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called on game start and after save game to initialize player colors
function InitPlayerColorMapping()
	Display.SetPlayerColorMapping(8,13)
end
	
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
-- This function is called on game start after all initialization is done
function FirstMapAction()

    Briefing_SetParameter(_standard, 1.4, 3200, 35, 1800, 35)

    IronDefTroups()
	createArmyBandits()
	createArmyTowerBandits()
	StartSimpleJob("Wegweiser1")
    StartSimpleJob("DemoWache")
    MakeInvulnerable("Tower")

    CreateMilitaryGroup(2, Entities.CU_BlackKnight_LeaderMace1, 4, GetPosition("Soldier1"))
    CreateMilitaryGroup(2, Entities.CU_BanditLeaderBow1, 4, GetPosition("Soldier1"))

    CreateMilitaryGroup(2, Entities.CU_BlackKnight_LeaderMace1, 4, GetPosition("Soldier2"))
    CreateMilitaryGroup(2, Entities.CU_BlackKnight_LeaderMace1, 4, GetPosition("Soldier2"))

	BriefingIntro()
	CreateNpc_Major()

    CreateChest (GetPosition("chest1"),GibSchwefel)
    CreateChest (GetPosition("chest2"),GibGold)
    CreateChest (GetPosition("chest3"),GibEisen)

    CreateChestOpener( "pilgrim" )

    StartChestQuest()

    XGUIEng.ShowWidget( "CinematicMiniMapContainer", 0 )

    
    PilgrimDefeatJob = StartSimpleJob("PilgirmDefeat")

    SetHealth("Ruin1", 20)
    SetHealth("Ruin2", 23)
    SetHealth("Ruin3", 18)
    SetHealth("Ruin4", 27)
    SetHealth("Ruin5", 40)
    SetHealth("Ruin6", 35)

    ActivateBriefingsExpansion()

end
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function PilgirmDefeat()
    if IsDead("pilgrim") then
        Defeat()
        return true
    end
end
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function GibSchwefel()
    Logic.AddToPlayersGlobalResource(1, ResourceType.SulfurRaw, 300)
    Message("Ihr habt eine Kiste mit 300 Schwefel gefunden!")
  end
  function GibEisen()
    Logic.AddToPlayersGlobalResource(1, ResourceType.IronRaw, 500)
    Message("Ihr habt eine Kiste mit 500 Eisen gefunden!")
  end
  function GibGold()
    Logic.AddToPlayersGlobalResource(1, ResourceType.GoldRaw, 800)
    Message("Ihr habt eine Kiste mit 800 Gold gefunden!")
  end
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function Wegweiser1()
if IsNear("pilgrim","Wegweiser1",600) then
    GUI.MiniMapDebug_SetText("Weg bis Littleville 200m")
elseif
    IsNear("pilgrim","Signpost2",800) then
    GUI.MiniMapDebug_SetText("Littlevilles Schenke")
elseif 
    IsNear("pilgrim","Holzpfeiler3",750) then
    GUI.MiniMapDebug_SetText("Kreuzung zum Flussufer")
elseif 
    IsNear("pilgrim","Wegweiser3",700) then
    GUI.MiniMapDebug_SetText("Ostweg Richtung Wintersbach")
elseif 
    IsNear("pilgrim","Wegweiser2",700) then
    GUI.MiniMapDebug_SetText("Der Krisenhuegel.")
else
    GUI.MiniMapDebug_SetText("")
end
    return false
  end
--#############################################################################################
function QuestAuftrag()
	quest	= {
	id		= 1,
	type	= MAINQUEST_OPEN,
	title	="Erste Konflikte",
	text	="König Dario hat Pilgrim gesandt im Ostreich nach dem rechten zu sehen, da Meldungen über Unruhen und Überfälle aus dem Ostreich hervorgingen. Eure Aufgabe ist es den Siedlern von Littleville den Frieden zu bringen. Hinweis: Es gibt Nebenaufgaben von den Bewohnern Littlevilles. Diese sind nicht zwingend notwendig, liefern aber Hinweise und Hilfestellungen die zur Story und dem gewinnen der Karte beitragen. Tipp: Sprecht daher trotzdem mit ihnen und lest gut mit! Viele Dinge werden nicht zwangsläufig erläutert. Außerdem hilft es, die Karte gut zu erkunden. Vielleicht findet ihr etwas, das euch weiterhilft.",
	}
	Logic.AddQuest(1, quest.id, quest.type, quest.title, quest.text,1)
	--HauptaufgabeQuest = quest.id
end
function NebenAuftrag()
	quest	= {
	id		= 2,
	type	= SUBQUEST_OPEN,
	title	="Das genaue Problem",
	text	="Sucht den Bürgermeister des Grenzdorfs Littleville auf und findet heraus, was hier im Osten los ist. Pilgrim darf bis dahin nicht sterben!",
	}
	Logic.AddQuest(1, quest.id, quest.type, quest.title, quest.text,1)
	--NebenaufgabeQuest = quest.id
end
function NebenAuftrag2()
	quest	= {
	id		= 3,
	type	= SUBQUEST_OPEN,
	title	="Sucht nach Hinweisen",
	text	="Sprecht mit den anderen Siedlern, die der Bürgermeister erwähnt hat. Vielleicht hat der ein oder andere Hinweise oder Belohnungen parat, die euch helfen können.",
	}
	Logic.AddQuest(1, quest.id, quest.type, quest.title, quest.text,1)
	--NebenaufgabeQuest = quest.id
end
function NebenAuftrag3()
	quest	= {
	id		= 4,
	type	= SUBQUEST_OPEN,
	title	="Turmausbau",
	text	="Die Verteidigung Littlevilles hat die besten Zeiten bereits hinter sich. Gegen einen Tribut würde der Bürgermeister die Türme ausbauen können. Schaut daher in euer Tributmenü.",
	}
	Logic.AddQuest(1, quest.id, quest.type, quest.title, quest.text,1)
	--NebenaufgabeQuest = quest.id
end
function NebenAuftrag12()
	quest	= {
	id		= 13,
	type	= SUBQUEST_OPEN,
	title	="Barbaren in eurer Base",
	text	="Bezwingt die Gegner in der Nähe eurer Basis. Achtet aber auf die Worte des Bürgermeisters. Ihr wisst nicht, wie die Barbaren darauf reagieren werden! Hinweis: Das Hauptlager der Barbaren ist noch unangreifbar. Ein Vorstoß dorthin lohnt sich nicht.",
	}
	Logic.AddQuest(1, quest.id, quest.type, quest.title, quest.text,1)
	--NebenaufgabeQuest = quest.id
end
function NebenAuftrag4()
	quest	= {
	id		= 5,
	type	= SUBQUEST_OPEN,
	title	="Das Steinfeld",
	text	="Räumt die Steine vom Feld weg. Der alte Jenkins hat vielleicht ein paar Infos für euch. Die Leibeigenen gehen wieder an Littleville über, wenn dies geschehen ist.",
	}
	Logic.AddQuest(1, quest.id, quest.type, quest.title, quest.text,1)
	--NebenaufgabeQuest = quest.id
end
function NebenAuftrag5()
	quest	= {
	id		= 6,
	type	= SUBQUEST_OPEN,
	title	="Gesuchte Wuffis",
	text	="Sucht die Begleiter von Jeff. Es sind 3 Stück der Zahl und sie befinden sich im Osten auf der Flusseite (wohlgemerkt an beiden Ufern). Er kann euch im Gegenzug sicherlich mehr zur aktuellen Lage sagen.",
	}
	Logic.AddQuest(1, quest.id, quest.type, quest.title, quest.text,1)
	--NebenaufgabeQuest = quest.id
end
function NebenAuftrag6()
	quest	= {
	id		= 7,
	type	= SUBQUEST_OPEN,
	title	="Ruinen",
	text	="Zerstört die verbleibenden Ruinen in Littleville.",
	}
	Logic.AddQuest(1, quest.id, quest.type, quest.title, quest.text,1)
	--NebenaufgabeQuest = quest.id
end
function NebenAuftrag7()
	quest	= {
	id		= 8,
	type	= SUBQUEST_OPEN,
	title	="Verteidigunszahlung",
	text	="Zahlt dem Sheriff die geforderten Ressourcen, damit Littleville wieder eigene Truppen aufbringen kann.",
	}
	Logic.AddQuest(1, quest.id, quest.type, quest.title, quest.text,1)
	--NebenaufgabeQuest = quest.id
end
function NebenAuftrag8()
	quest	= {
	id		= 9,
	type	= SUBQUEST_OPEN,
	title	="Vorbereitungen",
	text	="Baut eure Basis nun so weit es geht auf. Ihr habt nach Drakes Vermutungen 15 Minuten bis die Barbaren etwas unternehmen werden. Bis dahin solltet ihr über ein ausreichend großes Militär verfügen. Tipp: Wenn ihr Littlevilles Militärforderung bezahlt habt, werden sie euch unterstützen.",
	}
	Logic.AddQuest(1, quest.id, quest.type, quest.title, quest.text,1)
	--NebenaufgabeQuest = quest.id
end
function NebenAuftrag9()
	quest	= {
	id		= 10,
	type	= SUBQUEST_OPEN,
	title	="Der Angriff",
	text	="Die Barbaren planen einen Angriff auf Littleville. Der Landsitz und das Dorfzentrum Littlevilles dürfen unter keinen Umständen fallen. Das Selbe gilt für eure Burg! Hinweis: Das Hauptlager der Barbaren ist weiterhin nicht angreifbar.",
	}
	Logic.AddQuest(1, quest.id, quest.type, quest.title, quest.text,1)
	--NebenaufgabeQuest = quest.id
end
function Nebenauftrag10()
    quest	= {
        id		= 11,
        type	= SUBQUEST_OPEN,
        title	="Gegenoffensive",
        text	="Zerstört die feindliche Basis! Littleville wird euch unterstützen, kann aber aus Mangel an Kampfressourcen nur einmal angreifen. Tipp: ..Was sagte der Hundebesitzer noch gleich?.. Hinweis: Das Hauptlager der Barbaren ist nun angreifbar.",
        }
        Logic.AddQuest(1, quest.id, quest.type, quest.title, quest.text,1)
        --NebenaufgabeQuest = quest.id
    end
function Nebenauftrag11()
    quest	= {
        id		= 12,
        type	= SUBQUEST_OPEN,
        title	="Fragen über Fragen",
        text	="@color:0,255,0 Pilgrim: @color:255,255,255 Nachdem Vector nun besiegt ist, ist immernoch nicht klar was die Barbaren wollten. Was wollten sie verteidigen und warum das Großaufgebot? Hier stimmt wohl so einiges nicht. Außerdem.. hat nicht jemand was von Gestalt gesagt? Wie dem auch sei, ich muss mit dem Bürgermeister sprechen..",
         }
        Logic.AddQuest(1, quest.id, quest.type, quest.title, quest.text,1)
            --NebenaufgabeQuest = quest.id
end
function Nebenauftrag13()
    quest	= {
        id		= 14,
        type	= SUBQUEST_OPEN,
        title	="Warnfeuer",
        text	="Zerstört den aufgedeckten Turm, dann bezahlt den Tribut, um die noch unversehrten Städte und Dörfer im Ostreich zu warnen! Hinweis: Eine Belohnung gibt es nicht direkt. Diese wird aber möglicherweise in anderen Karten vorkommen.",
         }
        Logic.AddQuest(1, quest.id, quest.type, quest.title, quest.text,1)
            --NebenaufgabeQuest = quest.id
end
--#############################################################################################
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function BriefingIntro()
    local briefing = {};
    local AP, ASP = AddPages(briefing); 
    ASP("4thPerson","@color:255,200,0 Erzähler","Einen wunderschönen guten Ta ...", true);
    ASP("pilgrim","Pilgrim","... Moment.. Puhh.. Also.. Isch kann niet mieh...", true);
	ASP("4thPerson","@color:255,200,0 Erzähler","... Jaa, also was ich sagen wollte..", true);
    ASP("pilgrim","Pilgrim","Nu gebt mir doch nen Moment, dann kann ich auch zuhören...", true);
	ASP("4thPerson","@color:255,200,0 Erzähler","Ihr seid hier im Ostreich..", true);
	ASP("pilgrim","Pilgrim","Haaalt! Ich hab mich jetzt 715,25 Meilen bis hier geschleppt, nur um so ein paar Lümmeln zu helfen, also..", true);
	ASP("4thPerson","@color:255,200,0 Erzähler","Ja ja ja, so genau wollen wir es gar nicht wissen...", true);
	ASP("4thPerson","@color:255,0,0 Regisseur Nebelsoldat","Haltet euch an den Skript verdammt! Alles unfähige..", true);
	ASP("pilgrim","Pilgrim","...Das mit den Meilen stimmt aber... ", true);
	ASP("4thPerson","@color:255,200,0 Erzähler","Nun gut. Ihr seid hier im Ostreich angekommen. Littleville, das Grenzdorf dieses Reichs, ist nicht mehr weit von hier entfernt. Ihr solltet euch schnell dorthin begeben und nachsehen, was genau hier passiert ist.", true);
	ASP("pilgrim","@color:255,200,0 Erzähler","Pilgrim hat sich auf Befehl von König Dario hier her begeben, um nach dem Rechten zu sehen. Seht euch aber vor: Den Meldungen nach, scheint sich ein unbekannter Feind hier zu befinden.", true);
	ASP("pilgrim","@color:223,180,0 Euer Auftrag:","@color:255,127,0 Findet heraus was hier vor sich geht!", false);
		briefing.finished
		= function()
        DemoWache()
		QuestAuftrag()
		NebenAuftrag()
		Explore.Show("Gunther","Major", 1000)
		end
	StartBriefing(briefing);
    XGUIEng.ShowWidget( "CinematicMiniMapContainer", 0 );
end
--+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function DemoWache()
    if IsNear("pilgrim","Wache",2000) then
    CreateNpc_DemotivierteWache()
    Message("Hey ihr da!")
    return true
    end
end
function CreateNpc_DemotivierteWache()
    local npc = {
        name     = "Wache",
        marker = true,
        callback = function()
            Briefing_DemotivierteWache()
        end
    }    
    CreateNPC(npc)
end
function Briefing_DemotivierteWache()
    local briefing = {};
    local AP, ASP = AddPages(briefing); 
    ASP("Wache"," @color:50,50,220 Douglas die Wache","Wer seid ihr und was wollt ihr... ne.. ihr kommt nicht.. ach ne... ist doch eh egal, wir können dich vermutlich eh nicht aufhalten. Geht ruhig weiter.", true);
    briefing.finished
    = function()
    end
StartBriefing(briefing);
XGUIEng.ShowWidget( "CinematicMiniMapContainer", 0 );
end
--+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function BruderJo()
    if IsNear("pilgrim","Johannes",2500) then
    CreateNpc_BruderJohannes()
    Message("Hallo hier drüben! Könntet ihr bitte mal die Barbaren beseitigen?")
    return true
    end
end
function CreateNpc_BruderJohannes()
    local npc = {
        name     = "Johannes",
        marker = true,
        callback = function()
            Briefing_Johannes()
        end
    }    
    CreateNPC(npc)
end
function Briefing_Johannes()
    local briefing = {};
    local AP, ASP = AddPages(briefing); 
    ASP("Johannes"," @color:238,221,130 Bruder Johannes","Habt ihr die Barbaren hier beseitigt? Gut. Die meinten zu mir ich könnte zukünftig das zeitliche segnen aber so schnell gebe ich mich selber nicht hin.", true);
    ASP("pilgrim","Pilgrim","Ein wenig Dankbarkeit wäre ja schon höflicher, egal. Was wollten die von euch?", true);
    ASP("Johannes"," @color:238,221,130 Bruder Johannes","Eigentlich nur Infos über das Land und was es hier so gibt. Allerdings gibt es da eine Sache. Sie fragten explizit nach Kundschaftern Littlevilles. Da oftmals der ein oder andere hier an der Abtei vorbeikommt.", true);
    ASP("pilgrim","Pilgrim","Was hat es denn mit denen auf sich?", true);
    ASP("Johannes"," @color:238,221,130 Bruder Johannes","Ich gehe mal davon aus, dass sie verhindern wollten, dass man sie auskundschaftet. Aber da gibt es noch etwas unabhängig von den Barbaren.", true);
    ASP("pilgrim","Pilgrim","Was kann ich für euch tun? Und bitte keinen Ehering der im Gebüsch verloren ging.", true);
    ASP("Johannes"," @color:238,221,130 Bruder Johannes","Links von hier auf der Anhöhe ist ein Lagerfeuer, bzw. ein Haufen der mal hätte brennen sollen. Er signalisiert nahegelegenen Dörfern Gefahr.", true);
    ASP("Johannes"," @color:238,221,130 Bruder Johannes","Dörfer und Städte in der Nähe, die den Angriffen der Barbaren noch nicht zum Opfer gefallen sind, wie z.B. Gunners Hill, die Schwesterstädte oder das Ausbildungszentrum in den Lavafeldern von Mount Mash, würden damit gewarnt werden.", true);
    ASP("pilgrim","Pilgrim","Und was muss ich zum entzünden tun?", true);
    ASP("Johannes"," @color:238,221,130 Bruder Johannes","Zunächst müsste der Turm in der Nähe abgerissen werden. Sonst wissen die Barbaren von unserem Vorhaben und geben diese Info weiter. Danach bräuchte ich 100 Schwefel zum entzünden des Feuers.", true);
    ASP("pilgrim","Pilgrim","Kriege ich hin. Bis gleich!", true);
    ASP("Johannes","@color:223,180,0 Was tun?","@color:255,127,0 Zerstört erst den Turm. Danach könnt ihr über Tribute Johannes den Schwefel bezahlen!", false);
    briefing.finished
    = function()
        Explore.Show("Kill","Kill",800)
        StartSimpleJob("Turmdestroy")
        Nebenauftrag13()
    end
StartBriefing(briefing);
XGUIEng.ShowWidget( "CinematicMiniMapContainer", 0 );
end
function Turmdestroy()
    if IsNear("pilgrim","Kill",1000) then
        Explore.Hide("Kill")
    end
    if IsDead("Kill") then
        TributLagerfeuer()
    return true
    end
end
function TributLagerfeuer()
    local tribute =  {};
        tribute.playerId = 1;
        tribute.text = "Bezahlt die 100 Schwefel um andere Dörfer und Städte zukünftig warnen zu können!";
        tribute.cost = { Sulfur = 100 };
        tribute.Callback = TributLagerfeuerBezahlt;
        AddTribute( tribute );
end
    function TributLagerfeuerBezahlt()
        ReplaceEntity("Lagerfeuer", Entities.XD_SingnalFireOn)
        Briefing_Johannes2()
    end
function Briefing_Johannes2()
        local briefing = {};
        local AP, ASP = AddPages(briefing); 
        ASP("Lagerfeuer"," @color:238,221,130 Bruder Johannes","Danke, nun sollten alle gewarnt werden, wenn die Feuer weitergeleitet werden.  Ich wünsche euch weiterhin viel Glück!", true);
        briefing.finished
        = function()
        Logic.RemoveQuest(1,14)
        end
    StartBriefing(briefing);
    XGUIEng.ShowWidget( "CinematicMiniMapContainer", 0 );
end
--+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function CreateNpc_Major()
    local npc = {
        name     = "Major",
        marker = true,
        callback = function()
            Briefing_Major()
        end
    }    
    CreateNPC(npc)
end
function Briefing_Major()
    Explore.Show("Ruin1","Ruin1",1000)
    Explore.Show("Ruin2","Ruin2",1000)
    Explore.Show("Ruin3","Ruin3",1000)
    Explore.Show("Ruin4","Ruin4",1000)
    Explore.Show("Ruin5","Ruin5",1000)
    Explore.Show("Ruin6","Ruin6",1000)
    Explore.Show("BurgBriefing","BurgBriefing",2000)
    local briefing = {};
    local AP, ASP = AddPages(briefing); 
    ASP("Major","@color:255,127,0 Bürgermeister Bryan","Seid Willkommen in Littleville. Ihr müsst Pilgrim sein, stimmt's?", true);
    ASP("pilgrim","Pilgrim","Ja, der bin ich. Ich bin auf Befehl des Königs hier um nach dem Rechten zu sehen. Was ist hier denn passiert? Es sieht so aus, als wäre hier die Post abgegangen.", true);
    ASP("Major","@color:255,127,0 Bürgermeister Bryan","Si, diese Barbaren, die sich auf der anderen Flusseite breit gemacht haben, greifen uns seit Monaten an und verwüsten alles. Vor kurzem aber haben die Angriffe aufgehört.", true);
    ASP("Ruin1","@color:255,127,0 Bürgermeister Bryan","Das sind die Auswirkungen dieser Angriffe", true);
    ASP("Ruin2","@color:255,127,0 Bürgermeister Bryan","Wie zum Besipiel hier.", true);
    ASP("Tree","@color:255,127,0 Bürgermeister Bryan","Oder aber auch hier..", true);
    ASP("Ruin6","@color:255,127,0 Bürgermeister Bryan","Auch unsere Einzigen Verteidigungstürme mussten leiden...", true);
    ASP("Ruin5","@color:255,127,0 Bürgermeister Bryan","Damals hatten die noch gut Feuer unter der Haube..", true);
    ASP("pilgrim","Pilgrim","Na dann wird es ja höchste Eiszeit, diesen Barbaren mal eine Lektion zu erteilen.", true);
    ASP("Major","@color:255,127,0 Bürgermeister Bryan","Genau, aber bevor ich es vergesse...", true);
    ASP("BurgBriefing","@color:255,127,0 Bürgermeister Bryan","Hier liegt ein ehemaliger Stützpunkt von uns, der zur Leitung der Grenze gedacht war. Wir überstellen ihn euch mit allem was noch übrig ist, da wir keinen Nutzen mehr von diesem vermoderten Platz haben.", true);
    ASP("drake","@color:255,127,0 Bürgermeister Bryan","Ungünstigerweise berichtet Drake, dass in der Nähe des Stützpunktes weitere Barbaren sind, die wichtige Aufbauressourcen bewachen. Bitte vertreibt sie von dort. Seid aber vorsichtig, denn wir wissen nicht, wie diese Ketzer aus ihrem Hauptlager im Westen reagieren werden, sollten wir sie vertreiben.", true);
    ASP("Major","@color:255,127,0 Bürgermeister Bryan","Des Weiteren sind wir bis auf unsere kleine Stadtwache völlig entmilitarisiert. Wir haben nicht mehr die Mittel für eine Verteidigung, wie den Ausbau unserer Türme, daher wären wir euch dankbar, wenn ihr die nötigen Mittel besorgen könntet.", true);
    ASP("pilgrim","Pilgrim","Das sollte kein Problem sein. Mit solchen Aufgaben bin ich vertraut.", true);
    ASP("Major","@color:255,127,0 Bürgermeister Bryan","Dankesehr. Ihr seid zu gütig.", true);
    ASP("pilgrim","Pilgrim","Wenn ich aber vielleicht eine Frage gestatten dürfte.. Wer sind diese Barbaren und warum sind sie auf das Ostreich aus?", true);
    ASP("Major","@color:255,127,0 Bürgermeister Bryan","Naja, Gerüchten zu Folge sind sie auf Mount Glen aus. Dort soll die mächtige Felsenfestung von General Juno, einem der mächtigsten Ritter des Landes, sein.", true);
    ASP("pilgrim","Pilgrim","Aber was treibt sie dann hier hin? General Juno zu besiegen sollte eher alle Aufmerksamkeit auf sich ziehen...", true);
    ASP("Major","@color:255,127,0 Bürgermeister Bryan","Das weiß auch ich nicht. Tut mir leid.", true);
    ASP("pilgrim","Pilgrim","Das hört sich nach einem harten und steinigen Weg an, aber was hab ich zu meinen Besten Zeiten nicht schon gemeistert!", true);
    ASP("Major","@color:255,127,0 Bürgermeister Bryan","Gut, wir werden euch als Dorf natürlich zur Seite stehen mit allem was wir haben. Hier hilft jeder Jedem. Apropos, redet außerdem bitte zuerst mit dem Sheriff und dann den anderen Leuten hier. Sie sollten euch behilflich sein können.", true);
    ASP("Major","@color:223,180,0 Euer Auftrag:","@color:255,127,0 1.Besiegt die Barbaren nahe eurer Basis. 2. Redet mit dem Sheriff und dann den Siedlern 3. (optional:) Zahlt die nötigen Ressourcen für die Verteidigung Littlevilles.", false);
		briefing.finished
		= function()
        EndJob(PilgrimDefeatJob)
        Marker()
		TributLittlevilleUpgrade()
		Logic.RemoveQuest(1,2)
		CreateNpc_Sheriff()
		NebenAuftrag2()
		NebenAuftrag3()
        NebenAuftrag12()
		ActivateShareExploration( 1,8, true )
        Hide()
        StartSimpleJob("CounterCondition")
        MakeVulnerable("Tower")
        CreateNpc_NeuerTurmTyp()
		ChangePlayer("Haus",1)
		ChangePlayer("Haus2",1)
		ChangePlayer("Haus3",1)
		ChangePlayer("Haus4",1)
        Logic.SetEntityName(ChangePlayer("Burg1",1), "Burg1")
		ChangePlayer("senf1",1)
		ChangePlayer("senf2",1)
		ChangePlayer("senf3",1)
		ChangePlayer("senf4",1)
		ChangePlayer("Blume",1)
		ChangePlayer("Blume2",1)
		AddRessources()
		end
	StartBriefing(briefing);
    XGUIEng.ShowWidget( "CinematicMiniMapContainer", 0 );
end
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function Hide()
Explore.Hide("Ruin1")
Explore.Hide("Ruin2")
Explore.Hide("Ruin3")
Explore.Hide("Ruin4")
Explore.Hide("Ruin5")
Explore.Hide("Ruin6")
Explore.Hide("Major")
end
--+++++++++++++++++++++++++++++++++++++++++++-markers-++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function Marker()
    GUI.CreateMinimapMarker(27400.00, 4900.00, 3)
end
function Marker2()
    GUI.CreateMinimapMarker(11014.96, 38767.22 , 3)
end
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function AddRessources()
    AddStone(1, 300)
    AddWood(1, 500)
    AddClay(1, 600)
    AddGold(1, 800)
    AddIron(1, 200)
end
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function TributLittlevilleUpgrade()
local tribute =  {};
	tribute.playerId = 1;
	tribute.text = "Zahlt 800 Holz und 1200 Steine, damit die Verteidigung Littlevilles wieder in Stand gesetzt wird.";
	tribute.cost = { Wood = 800, Stone = 1200 };
	tribute.Callback = TributTurmausbauBezahlt;
	AddTribute( tribute );
end
function TributTurmausbauBezahlt()
    AddStone(8, 1200)
    AddWood(8, 800)
    StartSimpleHiResJob("ausbaubitte")
    Briefing_Major2()   
end
function ausbaubitte()
   GUI.UpgradeSingleBuilding(GetEntityId("Turm1"))
   GUI.UpgradeSingleBuilding(GetEntityId("Turm2"))
   GUI.UpgradeSingleBuilding(GetEntityId("Turm3"))
   GUI.UpgradeSingleBuilding(GetEntityId("Turm4"))
    return true
end
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function QuestDestroyRuins()
    StartSimpleJob("DestroyRuins")
    GUIQuestTools.StartQuestInformation("Ruin", "CM02_01_HugeBridge/QI_briefingBuilder1", 1, 1)
    GUIQuestTools.UpdateQuestInformationTooltip = function()
        XGUIEng.SetText(XGUIEng.GetWidgetID("QuestInformationTooltipText"), "Zerstört die Ruinen")
    end
end

function DestroyRuins()
	local RuinsDead = 0
    local Ruins = 6
    for i = 1,6 do
        if IsDead("Ruin"..i) then
            RuinsDead = RuinsDead + 1
        end
    GUIQuestTools.UpdateQuestInformationString(RuinsDead .. "/" .. Ruins)
    end
    if RuinsDead >= Ruins then
        GUIQuestTools.DisableQuestInformation()
        Briefing_Sheriff3()
    return true
    end
end
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function TributLittlevilleArmy()
local tribute =  {};
	tribute.playerId = 1;
	tribute.text = "Zahlt 1000 Gold, 400 Schwefel und 500 Eisen um Littlevills Militär aufstocken zu können.";
	tribute.cost = { Gold = 1000, Sulfur = 400, Iron = 500 };
	tribute.Callback = TributLittlevilleArmyBezahlt;
	AddTribute( tribute );
end
function TributLittlevilleArmyBezahlt()
    AddGold(8, 1000)
    AddSulfur(8, 400)
    AddIron(8, 500)
	StartSimpleJob("LittlevilleTroups")
	Briefing_Sheriff2()
end
function LittlevilleTroups()
    local _posTable = GetPosition("Lancer_Pos")

	CreateMilitaryGroup(8, Entities.PU_LeaderSword2, 4, GetPosition("SuppPos"),"Sword1")
    Logic.LeaderChangeFormationType(GetID("Sword1"), 4)
    Logic.GroupAttackMove(GetID("Sword1"), _posTable.X -400, _posTable.Y +400, 75)

	CreateMilitaryGroup(8, Entities.PU_LeaderSword2, 4, GetPosition("SuppPos"),"Sword2")
    Logic.LeaderChangeFormationType(GetID("Sword2"), 4)
    Logic.GroupAttackMove(GetID("Sword2"), _posTable.X +400, _posTable.Y +400, 75)

	CreateMilitaryGroup(8, Entities.PU_LeaderRifle1, 4, GetPosition("SuppPos"),"Rifle1")
    Logic.LeaderChangeFormationType(GetID("Rifle1"), 4)
    Logic.GroupAttackMove(GetID("Rifle1"), _posTable.X, _posTable.Y, 75)

	CreateMilitaryGroup(8, Entities.PU_LeaderRifle1, 4, GetPosition("SuppPos"),"Rifle2")
    Logic.LeaderChangeFormationType(GetID("Rifle2"), 4)
    Logic.GroupAttackMove(GetID("Rifle2"), _posTable.X -650, _posTable.Y, 75)

	CreateMilitaryGroup(8, Entities.PU_LeaderRifle1, 4, GetPosition("SuppPos"),"Rifle3")
    Logic.LeaderChangeFormationType(GetID("Rifle3"), 4)
    Logic.GroupAttackMove(GetID("Rifle3"), _posTable.X +450, _posTable.Y, 75)
    return true
end
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function IronDefTroups()
    local _posTable = GetPosition("IronDef")

	CreateMilitaryGroup(2, Entities.CU_BlackKnight_LeaderMace1, 4, GetPosition("IronDef"),"BowI1")
    Logic.LeaderChangeFormationType(GetID("BowI1"), 4)
    Logic.GroupAttackMove(GetID("BowI1"), _posTable.X -400, _posTable.Y +400, 270)

	CreateMilitaryGroup(2, Entities.PU_LeaderBow2, 4, GetPosition("IronDef"),"BowI2")
    Logic.LeaderChangeFormationType(GetID("BowI2"), 4)
    Logic.GroupAttackMove(GetID("BowI2"), _posTable.X +400, _posTable.Y +400, 270)

    return true
end
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function Briefing_Major2()
    local briefing = {};
    local AP, ASP = AddPages(briefing);
	ASP("Major","@color:255,127,0 Bürgermeister Bryan","Au ja, da kommt direkt mehr Wumms in die gute Stube. Mal sehen, was diese Ketzer auf der anderen Seite dagegen ausrichten können!", true);
	briefing.finished
		= function()
		Logic.RemoveQuest(1,4)
		end
	StartBriefing(briefing);
    XGUIEng.ShowWidget( "CinematicMiniMapContainer", 0 );
end
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function CreateNpc_Sheriff()
    local npc = {
        name     = "Sheriff", --Name des NPC
        marker = false, -- Ausrufezeichen
        callback = function()
            Briefing_Sheriff()  -- Wenn richtiger Held dann führe das Briefing aus
        end
    }    
    CreateNPC(npc)
end
function Briefing_Sheriff()
    Explore.Show("Iron","Iron",1000)
    local briefing = {};
    local AP, ASP = AddPages(briefing); 
    ASP("pilgrim","Pilgrim","Hallo, ihr müsst der Sheriff sein. Bürgermeister Bryan sagte mir, ich solle mit dir sprechen.", true);
    ASP("Sheriff","@color:173,255,47 Sheriff Tommy","Ja, ich bin Tommy. Und wer seid ihr denn?", true); 
    ASP("pilgrim","Pilgrim","Ich bin Pilgrim, Gesandter des Königs Dario. Ich bin hier um nach dem Rechten zu sehen. Und aktuell sieht es hier so aus, als wäre hier einiges nicht so.", true);
    ASP("Sheriff","@color:173,255,47 Sheriff Tommy","Ja das ist in der Tat wahr. Wir haben schon bessere Zeiten gesehen. Das Hauptproblem für uns ist das mangelnde Eisen hier in der Gegend.", true);
    ASP("Iron","@color:173,255,47 Sheriff Tommy","Unser Kundschafter berichtet, dass hier die Einzigen verbleibenden Eisenvorräte sind. Allerdings liegen sie auf der anderen Flusseite, wo auch die Barbaren ihr Unwesen treiben.", true);
    ASP("Iron","@color:173,255,47 Sheriff Tommy","Außerdem muss ich darauf hinweisen, dass andere Ressourcenvorkommen wie zum Beispiel ein Steinbruch oder angehäufter Schwefel, wenn ich mit da recht entsinne, auch auf jener Flusseite vorhanden sind.", true);
    ASP("pilgrim","Pilgrim","Das ist ungünstig. Gibt es weitere Infos über diese Barbaren-Stützpunkte, von denen ich hörte?", true);
    ASP("Sheriff","@color:173,255,47 Sheriff Tommy","Wir wissen, dass sie anders als andere Gruppierungen von Verbrechern höchst aggressiv kämpfen und nicht gerade unerfahren sind. Seid also vorsichtig, wenn ihr euch Ihnen nähert. Möglicherweise verfolgen sie euch.", true);
    ASP("Sheriff","@color:173,255,47 Sheriff Tommy","Außerdem haben sie ihre Kampfhunde in den Wäldern verteilt und Ballistatürme aufgestellt.", true);
    ASP("pilgrim","Pilgrim","Das heißt im Umkehrschluss, dass sie irgendetwas verteidigen wollen...", true);
    ASP("Sheriff","@color:173,255,47 Sheriff Tommy","Das vermute ich auch. Aber es gäbe da eine Sache, um die ich euch bitten müsste.", true);
    ASP("pilgrim","Pilgrim","Die da was genau wäre?", true);
    ASP("Sheriff","@color:173,255,47 Sheriff Tommy","Da unsere Stadtwache aus lediglich 5 Speerträgern besteht, bitten wir euch um eine Spende von 1000 Gold, 400 Schwefel und 500 Eisen. Damit können auch wir die Waffen wieder aufnehmen und gegen diese Verbecher ziehen können.", true);
    ASP("pilgrim","Pilgrim","Ich sehe mal, was sich auftreiben lässt.", true);
    ASP("Sheriff","@color:173,255,47 Sheriff Tommy","Gut und noch eine Bitte: Zerstört für uns diese Ruinen. Sie verhunzen unser schönes Dorf.", true);
        briefing.finished
		= function()
		QuestDestroyRuins()
		TributLittlevilleArmy()
		NebenAuftrag6()
		NebenAuftrag7()
        CreateNpc_BruderJohannes()
        CreateNpc_AlterMann()
		CreateNpc_Hundehalter()
        CreateNpc_ScoutCannon()
		end
	StartBriefing(briefing);
    XGUIEng.ShowWidget( "CinematicMiniMapContainer", 0 );
end
function Briefing_Sheriff2()
    local briefing = {};
    local AP, ASP = AddPages(briefing); 
    ASP("Sheriff","@color:173,255,47 Sheriff ","Da ist die Verstärkung, der wir solange entgegen gefiebert haben! Danke euch", true);
    ASP("drake","@color:238,221,130 Drake","Und weil ihr es nun geschafft habt Littlville wieder aufzuhelfen, werde ich, obwohl ich eigentlich zu interessant für sowas bin, mich euch anschließen!", true);
    	briefing.finished
		= function()
		ChangePlayer("drake",1)
		Logic.RemoveQuest(1,8)
        StartSimpleJob("TroupCheck2")
		end
	StartBriefing(briefing);
    XGUIEng.ShowWidget( "CinematicMiniMapContainer", 0 );
end
function Briefing_Sheriff3()
    local briefing = {};
    local AP, ASP = AddPages(briefing); 
    ASP("Sheriff","@color:173,255,47 Sheriff Tommy","Danke, dass ihr diese Ruinen beseitigt habt. Wir haben bei der Ausbeutung der Überreste ein paar Ressourcen für euch gefunden!", true);
    	briefing.finished
		= function()
		Logic.RemoveQuest(1,7)
		AddStone(1, 800)
		end
	StartBriefing(briefing);
    XGUIEng.ShowWidget( "CinematicMiniMapContainer", 0 );
end
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function CreateNpc_AlterMann()
    local npc = {
        name     = "SideQuest1", --Name des NPC
        LookAt = 0,
        marker = false, 
        callback = function()
            Briefing_AlterMann()  -- Wenn richtiger Held dann führe das Briefing aus
        end
    }    
    CreateNPC(npc)
end
function Briefing_AlterMann()
    local briefing = {};
    local AP, ASP = AddPages(briefing); 
    ASP("pilgrim","Pilgrim","Hallo, ihr müsst einer der Siedler sein von denen der Bürgermeister meinte, dass sie mir helfen können!", true);
    ASP("SideQuest1","@color:20,20,240 Der alte Jenkins","Ihr miesen Lappen, warum muss ich ausgerechnet euch hier bei mir haben?", true);
    ASP("pilgrim","Pilgrim","Ähm.. Hallo? Hören sie mich?", true);
    ASP("SideQuest1","@color:20,20,240 Der alte Jenkins","Ihr seid aber auch wirklich intelligent genug selbst die Fackel falsch herum in die Halterung zu stecken!", true);
    ASP("pilgrim","Pilgrim","Na dann warte ich einfach mal.", true);
    ASP("SideQuest1","@color:20,20,240 Der alte Jenkins","Wie kann es eigentlich sein, dass ihr weder Intelligenz noch Fähigkeiten von mir vererbt bekommen habt?!", true);
    ASP("Sohn1","Der Sohnemann","Aber Vater, rein mathematisch gesehen nur zu 50% meine Schuld, dass ich..", true);
    ASP("SideQuest1","@color:20,20,240 Der alte Jenkins","Schweig Weib!", true);
    ASP("pilgrim","Pilgrim","Jetzt haltet mal alle den Rand!!", true);
    LookAt("SideQuest1", "pilgrim")
    briefing.finished
    = function()
        Briefing_AlterMann3()
    end
    LookAt("SideQuest1", "Sohn1");
    StartBriefing(briefing);
    XGUIEng.ShowWidget( "CinematicMiniMapContainer", 0 );
end
function Briefing_AlterMann3()
        local briefing = {};
        local AP, ASP = AddPages(briefing); 
    ASP("SideQuest1","@color:20,20,240 Der alte Jenkins","Oh, Ja halli hallo hallöchen.", true);
    ASP("pilgrim","Pilgrim","(Warum auf einmal so freundlich? Egal einfach stur weitermachen.) Prinzipiell rate ich euch den Familientherapeuten aufzusuchen, aber deswegen bin ich nicht hier. Ihr müsst einer der Siedler sein, welche mir weiterhelfen können!", true);
    ASP("SideQuest1","@color:20,20,240 Der alte Jenkins","Sach bloß. Na dann hab ich direkt eine tolle Aufgabe für euch. Hier sind die drei Gonzos dieser Familie. ", true);
    ASP("SideQuest1","@color:20,20,240 Der alte Jenkins","Das sind Diodoros, Sergei und Ishmael", true);
    ASP("Sohn1","Der Sohnemann","Aber ich heiße doch...", true);
    ASP("SideQuest1","@color:20,20,240 Der alte Jenkins","Wie dem auch sei. Könnt ihr diese drei Unfähigen mal unter eure Obhut nehmen und sie die Steine vom Feld wegräumen lassen?", true);
    ASP("pilgrim","Pilgrim","Öhm Steine? Wie kommen die denn da hin?", true);
    ASP("SideQuest1","@color:20,20,240 Der alte Jenkins","Fragt einfach nicht.", true);
    ASP("pilgrim","Pilgrim","Ja das kann ich sicherlich. Könnt ihr mir dann im Gegenzug etwas über das Land hier oder diese Barbaren sagen?", true);
    ASP("SideQuest1","@color:20,20,240 Der alte Jenkins","Das sehen wir dann. Ein paar Infos hab ich definitiv.", true);
    ASP("pilgrim","Pilgrim","Gut, dann an die Arbeit Jungs!", true);
        briefing.finished
		= function()
		StartSimpleJob("SteineWeg")
		NebenAuftrag4()
		ChangePlayer("Sohn3",1)
		ChangePlayer("Sohn2",1)
		ChangePlayer("Sohn1",1)
		end
    LookAt("SideQuest1", "pilgrim");
	StartBriefing(briefing);
    XGUIEng.ShowWidget( "CinematicMiniMapContainer", 0 );
end
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function SteineWeg()
	if not IsExisting("Stone1") and not IsExisting("Stone2") then
	CreateNpc_AlterMann2()
    ChangePlayer("Sohn3",8)
    ChangePlayer("Sohn2",8)
    ChangePlayer("Sohn1",8)
	return true
	end
end
function CreateNpc_AlterMann2()
    local npc = {
        name     = "SideQuest1", --Name des NPC
        marker = true, -- Ausrufezeichen
        callback = function()
            Briefing_AlterMann2()  -- Wenn richtiger Held dann führe das Briefing aus
        end
    }    
    CreateNPC(npc)
end
function Briefing_AlterMann2()
    local briefing = {};
    local AP, ASP = AddPages(briefing);
    ASP("pilgrim","Pilgrim","Arbeit erledigt. Keine Steine mehr auf ihrem Feld.", true);
    ASP("SideQuest1","@color:20,20,240 Der alte Jenkins","Und diese Pflaumen von Söhnen haben es geschafft?", true);
    ASP("pilgrim","Pilgrim","Ja, das haben sie. Soll ich es euch beweisen?", true);
    ASP("SideQuest1","@color:20,20,240 Der alte Jenkins","Ne ne, ich denke mal, wenn ihr es geschafft habt, diese Dumpfbacken einen Auftrag fertigstellen zu lassen, ohne das vorzeitig die Welt untergeht oder irgendetwas wahrscheinlicheres passiert dann...", true);
    ASP("pilgrim","Pilgrim","Ähem. Ich wollte eigentlich ein paar Infos.", true);
    ASP("SideQuest1","@color:20,20,240 Der alte Jenkins","Ich meine, dass ich Aris ... spüren dürfte, wäre ja theoretisch wahrscheinlicher..", true);
    ASP("pilgrim","Pilgrim","Genug! Infos, ich brauche Infos!", true);
    ASP("SideQuest1","@color:20,20,240 Der alte Jenkins","Achso, ähm ja. Also was ich euch sagen kann. Auf der anderen Seite des Flusses hab ich damals ein großes Haus besessen. Es wurde eingerissen, als diese Barbaren kamen. Es könnte euch von Nutzen sein.", true);
    ASP("pilgrim","Pilgrim","Sonst nocht etwas, was es zu wissen gäbe?", true);
    ASP("SideQuest1","@color:20,20,240 Der alte Jenkins","Ja mei, ich meine mich zu erinnern können, dass  eine finstere Gestalt hier in der Gegend am herumlungern war. Es war definitiv kein Barbar aber vielleicht war das nur Einbildung...", true);
    ASP("pilgrim","Pilgrim","(Okay, vielleicht auch noch ab zum Psychotherapeuten.) Man sieht sich! ...", true);
    	briefing.finished
		= function()
		Logic.RemoveQuest(1,5)
        CreateNpc_Wache()
		end
	StartBriefing(briefing);
    XGUIEng.ShowWidget( "CinematicMiniMapContainer", 0 );
end
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function CreateNpc_Hundehalter()
    local npc = {
        name     = "SideQuest2", --Name des NPC
        marker = false, -- Ausrufezeichen
        callback = function()
            Briefing_Hundehalter()  -- Wenn richtiger Held dann führe das Briefing aus
        end
    }    
    CreateNPC(npc)
end
function Briefing_Hundehalter()
    local briefing = {};
    local AP, ASP = AddPages(briefing); 
    ASP("SideQuest2","@color:200,100,200 Hundehalter Jeff","Hallo, wer seid ihr denn?", true);
    ASP("pilgrim","Pilgrim","Ich bin Pilgrim, ein Gesandter von König Dario. Der Bürgermeister sagte mir, die Leute hier können mir behilflich sein?", true);
    ASP("SideQuest2","@color:200,100,200 Hundehalter Jeff","Oh hoher Besuch! Ich nehme an ihr wollt etwas über diese Barbaren oder das kleine Landstückchen hier wissen?", true);
    ASP("pilgrim","Pilgrim","Das wäre schonmal ein guter Anfang.", true);
    ASP("SideQuest2","@color:200,100,200 Hundehalter Jeff","Ich kann euch gerne etwas über diese Barbaren sagen, aber vorher würde ich euch um einen Gefallen bitten.", true);
    ASP("pilgrim","Pilgrim","Aber bitte nicht wieder irgendeine übersteuerte 2000 - aufwärts - Talerforderung...", true);
    ASP("SideQuest2","@color:200,100,200 Hundehalter Jeff","Nein nein, es geht sich um meine Liebsten Begleiter: Benno, Leno und Django.", true);
    ASP("pilgrim","Pilgrim","Das hört sich schwer nach deinen Haustieren an.", true);
    ASP("SideQuest2","@color:200,100,200 Hundehalter Jeff","Jaa, in der Tat. Sie sind mir vor zwei Wochen entflohen, nachdem wir von der anderen Seite Kanonenexplosionen gehört haben.", true);
    ASP("pilgrim","Pilgrim","(Grummel..) ...Das ist ja interessant.... Kanonen...", true);
    ASP("SideQuest2","@color:200,100,200 Hundehalter Jeff","Sie sind hier in der Gegend in der Nähe des Wassers im Osten, irgendwo verteilt. Ich hoffe ihr findet sie für mich!", true);
    ASP("pilgrim","Pilgrim","Was? Oh ähm ja ja ich werde sie finden.", true);
    ASP("SideQuest2","@color:200,100,200 Hundehalter Jeff","Danke euch. Wir sehen uns mein Freund!", true);
    ASP("pilgrim","Pilgrim","(Grummel...grummel...) Kanonen nur für so ein Dorf wie Littleville? Irgendetwas stimmt hier absolut nicht.", true);
        briefing.finished
		= function()
		NebenAuftrag5()
        wuffisuche()
        StartSimpleJob("wufficheck")
		end
	StartBriefing(briefing);
    XGUIEng.ShowWidget( "CinematicMiniMapContainer", 0 );
end
function wuffisuche()
    CreateNpc_wuffi()
    CreateNpc_wuffi2()
    CreateNpc_wuffi3()  
end
function CreateNpc_wuffi()
    local npc = {
        name     = "wuffi", --Name des NPC
        marker = false, -- Ausrufezeichen
        callback = function()
            Briefing_wuffi()  -- Wenn richtiger Held dann führe das Briefing aus
        end
    }    
    CreateNPC(npc)
end
function CreateNpc_wuffi2()
    local npc = {
        name     = "wuffi2", --Name des NPC
        marker = false, -- Ausrufezeichen
        callback = function()
            Briefing_wuffi2()  -- Wenn richtiger Held dann führe das Briefing aus
        end
    }    
    CreateNPC(npc)
end
function CreateNpc_wuffi3()
    local npc = {
        name     = "wuffi3", --Name des NPC
        marker = false, -- Ausrufezeichen
        callback = function()
            Briefing_wuffi3()  -- Wenn richtiger Held dann führe das Briefing aus
        end
    }    
    CreateNPC(npc)
end
function Briefing_wuffi()
    local briefing = {};
    local AP, ASP = AddPages(briefing); 
    ASP("pilgrim","Pilgrim","Na kleiner Lurch.. Bist du Leno?", true);
    ASP("wuffi","Benno","grrr. . wau wau..", true);
    ASP("pilgrim","Pilgrim","Benno? Ja, du musst Benno sein, ja feini, geh mal zu deinem Herrchen!", true);
    ASP("wuffi","Benno","hechel hechel hechel.", true);
		briefing.finished
		= function()
            Move("wuffi","gatherpoint") 
		end
	StartBriefing(briefing);
    XGUIEng.ShowWidget( "CinematicMiniMapContainer", 0 );
end
function Briefing_wuffi2()
    local briefing = {};
    local AP, ASP = AddPages(briefing); 
    ASP("pilgrim","Pilgrim","Ach ne, ja gucke mal du Lümmel.", true);
    ASP("wuffi2","Django","grrr.......", true);
    ASP("pilgrim","Pilgrim","Du bist so ein richtiger Django, ja dann geh mal zu Papa Jeff.", true);
		briefing.finished
		= function()
            Move("wuffi2","gatherpoint")
		end
	StartBriefing(briefing);
    XGUIEng.ShowWidget( "CinematicMiniMapContainer", 0 );
end
function Briefing_wuffi3()
    local briefing = {};
    local AP, ASP = AddPages(briefing); 
    ASP("pilgrim","Pilgrim","Deine Kumpanen sind bei Papa Herrchen. Na los, geh schon Leno.", true);
    ASP("wuffi3","Leno","O_o ? wau wau ? hechel hechel hechel.", true);
    ASP("pilgrim","Pilgrim","Ich disktuiere nicht mit dir! Ab!", true);
		briefing.finished
		= function()
            Move("wuffi3","gatherpoint")
		end
	StartBriefing(briefing);
    XGUIEng.ShowWidget( "CinematicMiniMapContainer", 0 );
end
function wufficheck()
    if IsNear("wuffi","SideQuest2", 1000) and IsNear("wuffi2","SideQuest2", 1000) and IsNear("wuffi3","SideQuest2", 1000) then
        CreateNpc_Hundehalter2()
return true
    end
return false
end
function CreateNpc_Hundehalter2()
    local npc = {
        name     = "SideQuest2", --Name des NPC
        marker = false, -- Ausrufezeichen
        callback = function()
            Briefing_Hundehalter2()  -- Wenn richtiger Held dann führe das Briefing aus
        end
    }    
    CreateNPC(npc)
end
function Briefing_Hundehalter2() 
    local briefing = {};
    local AP, ASP = AddPages(briefing); 
    ASP("SideQuest2","@color:200,100,200 Hundehalter Jeff","Ich danke euch herzlichst. Ihr bekommt natürlich eine Belohnung...", true);
    ASP("pilgrim","Pilgrim","Ach wie schön, dass ist aber....", true);
    ASP("SideQuest2","@color:200,100,200 Hundehalter Jeff","...also meine Begleiter natürlich. Moment... ich wollte doch... Ach ja, wegen dem Tipp: Diese Kanonen sind verdammt mächtig, wenn man nach der Lautstärke geht teilen sie entsprechend aus. Rüstet euch also erstmal lieber aus und stellt ein paar gute Truppen auf, bevor ihr euch in den Westen wagt.", true);
    ASP("SideQuest2","@color:200,100,200 Hundehalter Jeff","Wo wir schon einmal dabei sind.. Ich hab da ein Lied von Otto.", true);
    ASP("pilgrim","Pilgrim","Nein danke. Ich brauchte nur die Infos.", true);
    ASP("SideQuest2","@color:200,100,200 Hundehalter Jeff","Wenn mans lieb im Arme hält, das Hündchen ganz zufrieden bällt.", true);
    ASP("wuffi","Benno","wau                                                                          .", true);
    ASP("SideQuest2","@color:200,100,200 Hundehalter Jeff","Wenn man ihm das Öhrchen krault, könnt ihr hören wie es jault.", true);
    ASP("wuffi","Benno","auuuh                                                                        .", true);
    ASP("pilgrim","Pilgrim","Ne, das reicht jetzt auch.", true);
    briefing.finished
    = function()
        Logic.RemoveQuest(1,6)
    end
    StartBriefing(briefing);
    XGUIEng.ShowWidget( "CinematicMiniMapContainer", 0 );
end
--+++++++++++++++++++++++++++++++++++++++++++++++++-ScoutCannon-+++++++++++++++++++++++++++++++++++++++++++++++++++
function CreateNpc_ScoutCannon()
    local npc = {
        name     = "ScoutCannon", 
        marker = false, 
        callback = function()
            Briefing_ScoutgiveCannon()  
        end
    }    
    CreateNPC(npc)
end
function Briefing_ScoutgiveCannon() 
    local briefing = {};
    local AP, ASP = AddPages(briefing); 
    ASP("ScoutCannon","@color:0,255,0 Kundschafter Derrek","Hey ihr, schaut mal.", true);
    ASP("ScoutCannon","@color:0,255,0 Kundschafter Derrek","Da hinten ist eine alte Kanone! Das klapprige Gestell hab ich wieder aufgemotzt und Einsatzbereit gemacht. Für einen ganz, klitzekleinen, feinen aber vielleicht doch gemeinen  Betrag, könnt ihr sie haben!", true);
    ASP("pilgrim","Pilgrim","Wie viel kostet dieses Moped also konkret?", true);
    ASP("ScoutCannon","@color:0,255,0 Kundschafter Derrek","1500 Gold hätte ich gerne. Ich meine nur, weil ich sie mit viel Mühe wieder aufgebaut hab. Bezahlt sonst einfach den Betrag und wir sehen weiter!", true);
    briefing.finished
    = function()
        TributScoutCannon()
    end
    StartBriefing(briefing);
    XGUIEng.ShowWidget( "CinematicMiniMapContainer", 0 );
end
function TributScoutCannon()
    local tribute =  {};
        tribute.playerId = 1;
        tribute.text = "Zahlt Kundschafter Derrek 1500 Gold, damit die Kanone an euch übergeht!";
        tribute.cost = { Gold = 1500 };
        tribute.Callback = TributScoutCannonBezahlt;
        AddTribute( tribute );
    end
    function TributScoutCannonBezahlt()
        Briefing_ScoutCannon2()
    end
function Briefing_ScoutCannon2()
    local briefing = {};
    local AP, ASP = AddPages(briefing); 
    ASP("ScoutCannon","@color:0,255,0 Kundschafter Derrek","Die Firma dankt. Viel Spaß mit dem schönen aber doch irgendwie obszönen Gerät!", true);
    briefing.finished
    = function()
        ChangePlayer("FreeCannon",1)
    end
    StartBriefing(briefing);
    XGUIEng.ShowWidget( "CinematicMiniMapContainer", 0 );
end
--+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++--+++++++++++++++++
function CounterCondition()
    MakeInvulnerable("HQBandits")
    MakeInvulnerable("Bandit") 
    MakeInvulnerable("Bandit_Tent") 
    MakeInvulnerable("Kaserne")
    MakeInvulnerable("Schiessplatz")
    MakeInvulnerable("HQT1")
    MakeInvulnerable("HQT2")
    MakeInvulnerable("HQT3")
    MakeInvulnerable("HQT4")
	if IsDead ("Tower") then
	Briefing_Drake()
    return true
	end
end
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function Briefing_Drake()
    local briefing = {};
    local AP, ASP = AddPages(briefing);
    ASP("drake","@color:238,221,130  Drake","Jetzt wo der Turm gefallen ist, sollten wir uns vorsehen. Ich glaube nicht, dass die Barbaren uns damit davon kommen lassen. Mal sehen, was in näherer Zeit passiert. Mein Kundschafter spioniert derweil das Hauptlager aus. Ihr habt ca. 15min bis sich etwas tut.", true);
    ASP("drake","@color:238,221,130 Drake","Baut euch besser nun schnell auf, wer weiß was noch passieren wird.", true);
    	briefing.finished
    	= function()
        GUI.DestroyMinimapPulse(27400.00, 4900.00, 3)
    	 StartCountdown(15*60, warning , true)
    	NebenAuftrag8()
        Logic.RemoveQuest(1,13)
    	end
    StartBriefing(briefing);
    XGUIEng.ShowWidget( "CinematicMiniMapContainer", 0 );
end
--+++++++++++++++++++++++++++++++++++++++++++++++++++++++-WarningScout-+++++++++++++++++++++++++++++++++++++++++++++
function warning()
    SetEntityName(Logic.CreateEntity(Entities.PU_Scout, 34423.94921875, 23434.23046875, 0, 8), "WarnScout")
	Move("WarnScout","PosWarning")
    Briefing_Kundschafter()
    StartSimpleJob("TroupCheck")
end
function TroupCheck()
    if IsExisting("Sword1") and IsExisting("Sword2") and IsExisting("Rifle1") and IsExisting("Rifle2") and IsExisting("Rifle3") then
        local _posTable = GetPosition("DefPos")
        Logic.GroupAttackMove(GetID("Sword1"), _posTable.X -400, _posTable.Y +400, 90)
        Logic.GroupAttackMove(GetID("Sword2"), _posTable.X +400, _posTable.Y +400, 90)
        Logic.GroupAttackMove(GetID("Rifle1"), _posTable.X, _posTable.Y, 90)
        Logic.GroupAttackMove(GetID("Rifle2"), _posTable.X -600, _posTable.Y, 90)
        Logic.GroupAttackMove(GetID("Rifle3"), _posTable.X +600, _posTable.Y, 90)
    return true
    end
return false
end
function TroupCheck2()
    if IsExisting("Sword1") and IsExisting("Sword2") and IsExisting("Rifle1") and IsExisting("Rifle2") and IsExisting("Rifle3") then
        local _posTable = GetPosition("DefPos")
        Logic.GroupAttackMove(GetID("Sword1"), _posTable.X -400, _posTable.Y +400, 90)
        Logic.GroupAttackMove(GetID("Sword2"), _posTable.X +400, _posTable.Y +400, 90)
        Logic.GroupAttackMove(GetID("Rifle1"), _posTable.X, _posTable.Y, 90)
        Logic.GroupAttackMove(GetID("Rifle2"), _posTable.X -600, _posTable.Y, 90)
        Logic.GroupAttackMove(GetID("Rifle3"), _posTable.X +600, _posTable.Y, 90)
    return true
    end
return false
end
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function Briefing_Kundschafter()
    local briefing = {};
    local AP, ASP = AddPages(briefing); 
    AP{
        position = GetPosition("WarnScout"),
        title = "Kundschafter",
        text = "Sie kommen! Ich habe ein Gespräch der Banditen belauscht, sie werden bald angreifen. Ihr habt 3 Minuten bis sie kommen! Kämpft! Nein Flieht! Ruft die Luftwaffe! Macht irgendetwas! Wir werden alle sterben.. oder auch nicht.",
        dialog = true,
        action = function()
        Camera.FollowEntity(GetID("WarnScout"));
    end,
    }
    ASP("Sheriff","@color:173,255,47 Sheriff Tommy","Dann bereiten wir uns mal vor!", true);
    ASP("Takeover","@color:173,255,47 Sheriff Tommy","Hier ist eine Kanonengießerei. Ihr könnt sie benutzen, damit können wir sowieso nichts anfangen.", true);
    ASP("Sheriff","@color:173,255,47 Sheriff Tommy","Lasst und den Angriff bestehen und gewinnen!", true);
    ASP("Protect","@color:255,200,0 Erzähler","@color:255,127,0 Jetzt wisst ihr bescheid. Es wird Zeit diesen Kerlen ordentlich einen drüber zu geben!", true);
    ASP("Protect","@color:223,180,0 Euer Auftrag:","@color:255,127,0 Wehrt den Angriff dieser Barbaren ab. Weder der Landsitz von Littleville, deren Dorfzentrum, noch eure Burg dürfen fallen!", false);
    	briefing.finished
		= function()
		Logic.RemoveQuest(1,9)
		ChangePlayer("Takeover", 1)
		NebenAuftrag9()
        Marker2()
		StartCountdown(3*60, createArmyLittlevilleUA , true)
        StartSimpleJob("NiederlageBedingung")
        DestroyEntity("WarnScout")
        Logic.RemoveQuest(1,3)
		end
	StartBriefing(briefing);
    XGUIEng.ShowWidget( "CinematicMiniMapContainer", 0 );
end
--++++++++++++++++++++++++++++++++++++++++++++++-AttackLittleville-++++++++++++++++++++++++++++++++++++++++++++++++++
function LittlevilleAttack()
    CreateMilitaryGroup(8, Entities.PU_LeaderPoleArm2, 4, GetPosition("SuppPos"),"Pole1")
    Logic.LeaderChangeFormationType(GetID("Pole1"), 7)
	Attack("Pole1","Maindef")
	CreateMilitaryGroup(8, Entities.PU_LeaderPoleArm2, 4, GetPosition("SuppPos"),"Pole2")
    Logic.LeaderChangeFormationType(GetID("Pole2"), 7)
	Attack("Pole2","Maindef")
	CreateMilitaryGroup(8, Entities.PU_LeaderBow3, 6, GetPosition("SuppPos"),"Bow1")
    Logic.LeaderChangeFormationType(GetID("Bow1"), 3)
	Attack("Bow1","Maindef")
	CreateMilitaryGroup(8, Entities.PU_LeaderBow3, 6, GetPosition("SuppPos"),"Bow2")
    Logic.LeaderChangeFormationType(GetID("Bow2"), 3)
	Attack("Bow2","Maindef")
	CreateMilitaryGroup(8, Entities.PU_LeaderRifle1, 4, GetPosition("SuppPos"),"Rifle4")
    Logic.LeaderChangeFormationType(GetID("Rifle4"), 4)
	Attack("Rifle4","Maindef")
    StartSimpleJob("Sheriff")
end
function Sheriff()
    if IsDead("Pole1") and IsDead("Pole2") and IsDead("Bow1") and IsDead("Bow2") and IsDead("Rifle4") then
    SheriffBriefing4()
    return true
    end
end
function SheriffBriefing4()
    local briefing = {};
    local AP, ASP = AddPages(briefing); 
    ASP("Sheriff","@color:173,255,47 Sheriff Tommy","Uns geht der Saft aus. Ab hier müsst ihr übernehmen!", true);
        briefing.finished
        = function()
        end
    StartBriefing(briefing);
    XGUIEng.ShowWidget( "CinematicMiniMapContainer", 0 );
end
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function DestroyCondition()
    if not IsExisting("HQBandits") and not IsExisting("Bandit") and not IsExisting("Bandit_Tent") and not IsExisting("Tent") then
        CreateNpc_Vector()
        GUI.DestroyMinimapPulse(11014.96, 38767.22 , 3)
    return true
    else
    return false
    end
end
function CreateNpc_Vector()
    local npc = {
        name     = "Knight", 
        marker = false, 
        callback = function()
            Briefing_Vector()  
        end
    }    
    CreateNPC(npc)
end
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function Briefing_Vector()
    local briefing = {};
    local AP, ASP = AddPages(briefing); 
    ASP("pilgrim","Pilgrim","Eure Basis ist zerstört, gebt auf! Wir haben gewonnen!", true);
    ASP("Knight","@color:255,0,0 Barbarenanführer Vector","Na gut, ihr habt gewonnen! Was werdet ihr nun machen?", true);
    ASP("pilgrim","Pilgrim","Ich will von euch wissen, was das Ganze hier soll? Warum die Angriffe auf ein kleines wehrloses Dorf?! Und vor allem warum dafür so ein riesen Aufgebot?", true);
    ASP("Knight","@color:255,0,0 Barbarenanführer Vector","Ihr wisst ja scheinbar überhaupt nichts. Ehrlich gesagt, hab ich nicht die Absicht meine Pläne geschweige denn meine Mitstreiter zu verraten! Seht also zu, wie ihr zurecht kommt!", true);
    ASP("pilgrim","Pilgrim","Wenn das alles ist.. Sperrt ihn irgendwo hin und lasst ihn verrotten, hauptsache weg!", true);
        briefing.finished
        = function()
        SetNeutral(1,2)
        Logic.RemoveQuest(1,11)
        Nebenauftrag11()
        CreateNpc_Major2()
        DestroyEntity("Knight")
        end
    StartBriefing(briefing);
    XGUIEng.ShowWidget( "CinematicMiniMapContainer", 0 );
end
function CreateNpc_Major2()
    local npc = {
        name     = "Major", 
        marker = false, 
        callback = function()
            FinalBriefing()  
        end
    }    
    CreateNPC(npc)
end
--++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function FinalBriefing()
    local briefing = {};
    local AP, ASP = AddPages(briefing);
    ASP("pilgrim","Pilgrim","Wir haben den Anführer der Barbaren geschnappt und sie erfolgreich von hier vertrieben, aber der Anführer will mir nicht verraten, was sie hier wollten. Keiner scheint das hier zu wissen oder?", true);
    ASP("Major","@color:255,127,0 Bürgermeister Bryan","Tatsächlich wissen wir auch niente nada. Keiner kann sich hier irgendwas erklären.. Es ist nur gut, dass es aufgehört hat.", true);
    ASP("Major","@color:255,127,0 Bürgermeister Bryan","Apropos erklären. Ich schicke euch zukünftigt einen meiner Kundschafter mit. Er ist neutral gegenüber den meisten Fraktionen und kann auch in Zukunft auf diese Weise Informationen beschaffen.",true);
    ASP("pilgrim","Pilgrim","Ich danke euch. Wir sollten uns aber nun auf machen. Das nächste Ziel sind Wintersbach und Finsterwalde.", true);
    ASP("Major","@color:255,127,0 Bürgermeister Bryan","Oh weia.. Bewahrt aber einen kühlen Kopf. Diese Städte sind unsere Landeigenen Streithähne. Die könnten euch ziemlich auf den Dötz gehen.", true);
    ASP("pilgrim","Pilgrim","Ach, das krieg ich schon hin. Ich wünsche euch alles Gute.", true);
    ASP("Major","@color:255,127,0 Bürgermeister Bryan","Bis Bald!", true);
    ASP("4thPerson","@color:255,200,0 Nebelsoldat","Ihr seid nun am Ende der Karte angelangt. Ich bedanke mich fürs spielen und bitte um konstruktive Kritik. Hinweis: Wartet bis zum Ablauf des Countdowns für die Post Credit Scene! Falls nicht, könnt ihr hier verlassen", true);
    briefing.finished
    = function()
        Logic.RemoveQuest(1,1)
        Logic.RemoveQuest(1,12)
        StartCountdown(1*20, CutsceneAufruf , true)
    end
    Explore.Show("4thPerson","4thPerson",2000)
    StartBriefing(briefing);
    XGUIEng.ShowWidget( "CinematicMiniMapContainer", 0 );
end
function CutsceneAufruf()
    StartCutscene = function(_Name, _Callback)
        CutsceneCallback = _Callback
        Trigger.DisableTriggerSystem(1)
        Logic.SetGlobalInvulnerability(1)
        GUI.SetFeedbackSoundOutputState(0)
        Display.SetProgramOptionRenderOcclusionEffect(0)
        Input.CutsceneMode()
        Cutscene.Start(_Name)
        assert(cutsceneIsActive ~= true)
        cutsceneIsActive = true
        LocalMusic_UpdateMusic()
        Cutscene.Effect = Sound.GetVolumeAdjustment(3)
        Cutscene.Ambient = Sound.GetVolumeAdjustment(5)
        Cutscene.Music = Music.GetVolumeAdjustment()
        Sound.PlayFeedbackSound(0,0)
    end
    PrepareBriefing = function(_briefing)
        GUIAction_GoBackFromHawkViewInNormalView()
        Interface_SetCinematicMode(1)
        Camera.StopCameraFlight()
        Camera.ScrollUpdateZMode(0)
        Camera.RotSetAngle(-45)
        Display.SetRenderFogOfWar(1)
        GUI.MiniMap_SetRenderFogOfWar(1)
        briefingState.Effect = Sound.GetVolumeAdjustment(3)
        briefingState.Ambient = Sound.GetVolumeAdjustment(5)
        briefingState.Music = Music.GetVolumeAdjustment()
        Sound.PlayFeedbackSound(0,0)
        Input.CutsceneMode()
        GUI.SetFeedbackSoundOutputState(0)
        LocalMusic.SongLength = 0
        XGUIEng.ShowWidget("CinematicMiniMapContainer",1)
    end
    StartCutscene("PostCreditScene", NVScoutandBossTalkBriefing)
end
function NVScoutandBossTalkBriefing()
    Briefing_SetParameter(_standard, 0.9, 3200, 35, 1800, 35)
    local briefing = {};
    local AP, ASP = AddPages(briefing);
    ASP("NVMajor","@color:255,0,0 Lord Dracar","Du bist zurück, das wurde ja auch Zeit... Was hast du gesehen?", true);
    ASP("NVScout","Nebelvolk Kundschafter","Sie haben die Barbaren besiegt. Ich beobachte schon seit langem.. Man sollte diesen Pilgrim vielleicht doch nicht unterschätzen.", true);
    ASP("NVMajor","@color:255,0,0 Lord Dracar","Na schön.. Dann werde ich es wohl selbst in die Hand nehmen. Startet die Walze!", true);
    briefing.finished
    = function()
        Victory()
    end
    PostCreditBriefing_Music();
    Explore.Show("NVMajor","NVMajor",2000);
    StartBriefing(briefing);
    XGUIEng.ShowWidget( "CinematicMiniMapContainer", 0 );
end
function PostCreditBriefing_Music ()	
    Sound.StartMusic("maps\\user\\Die Belagerung des Ostreichs - Littleville\\MusicDangerAhead.mp3", 1800)
	LocalMusic.SongLength =  Logic.GetTime() + 72
end
--+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
function NiederlageBedingung()
	if not IsExisting("Protect") or not IsExisting("Burg1") or not IsExisting("DZ") then
        Defeat()
	return true
	end
end
--#############################################################################################
--#############################################################################################
function AddTribute( _tribute )
    assert( type( _tribute ) == "table", "Tribut muß ein Table sein" );
    assert( type( _tribute.text ) == "string", "Tribut.text muß ein String sein" );
    assert( type( _tribute.cost ) == "table", "Tribut.cost muß ein Table sein" );
    assert( type( _tribute.playerId ) == "number", "Tribut.playerId muß eine Nummer sein" );
    assert( not _tribute.Tribute , "Tribut.Tribute darf nicht vorbelegt sein");
    
    uniqueTributeCounter = uniqueTributeCounter or 1;
    _tribute.Tribute = uniqueTributeCounter;
    uniqueTributeCounter = uniqueTributeCounter + 1;
    
    local tResCost = {};
    for k, v in pairs( _tribute.cost ) do
        assert( ResourceType[k] );
        assert( type( v ) == "number" );
        table.insert( tResCost, ResourceType[k] );
        table.insert( tResCost, v );
    end
    
    Logic.AddTribute( _tribute.playerId, _tribute.Tribute, 0, 0, _tribute.text, unpack( tResCost ) );
    SetupTributePaid( _tribute );
    
    return _tribute.Tribute;
end
--#############################################################################################
function ActivateBriefingsExpansion()
	
	if not unpack{true} then 
		local unpack2
		unpack2 = function( _table, i )
			i = i or 1
			assert(type(_table) == "table")
			if i <= table.getn(_table) then
				return _table[i], unpack2(_table, i)
			end
		end
		unpack = unpack2
	end
	
	Briefing_ExtraOrig = Briefing_Extra
	Briefing_Extra = function( _v1, _v2 )
		-- bugfix; this button would stay in it's clicked state
		--> only visible when another MC page follows
		for i = 1, 2 do
			local theButton = "CinematicMC_Button" .. i
			XGUIEng.DisableButton(theButton, 1)
			XGUIEng.DisableButton(theButton, 0)
		end
		
		if _v1.action then
			assert( type(_v1.action) == "function" )
			if type(_v1.parameters) == "table" then 
				_v1.action(unpack(_v1.parameters))
			else
				_v1.action(_v1.parameters)
			end
		end
		
		Briefing_ExtraOrig( _v1, _v2 )
	end
	
	GameCallback_EscapeOrig = GameCallback_Escape
	
	-- some briefing GUI customization
	PrepareBriefing_Orig = PrepareBriefing
	PrepareBriefing = function(_briefing)
		PrepareBriefing_Orig(_briefing)
		-- allow to hide the minimap during briefing
		if not _briefing.showMinimap then
			XGUIEng.ShowWidget( "CinematicMiniMapContainer", 0 )
		end
	end
	
    StartBriefingOrig = StartBriefing;
    EndBriefingOrig = EndBriefing;
    MessageOrig = Message;
    CreateNPCOrig = CreateNPC;

    StartBriefing = function(_briefing)
                        assert(type(_briefing) == "table");
                        if _briefing.noEscape then
                            GameCallback_Escape = function() end;
                            briefingState.noEscape = true;
                        end
                        
                        StartBriefingOrig(Umlaute(_briefing));
                    end
    
    EndBriefing = function()
                      if briefingState.noEscape then
                          GameCallback_Escape = GameCallback_EscapeOrig;
                          briefingState.noEscape = nil;
                      end
                      
                      EndBriefingOrig();
                  end;
    
    Message = function(_text)
                  MessageOrig(Umlaute(tostring(_text)));
              end;
    
    CreateNPC = function(_npc)
                    CreateNPCOrig(Umlaute(_npc));
                end;
    
    Umlaute = function(_text)
                  local texttype = type(_text);
                  if texttype == "string" then
					  _text = string.gsub( _text, "ä", "\195\164" );
                      _text = string.gsub( _text, "ö", "\195\182" );
                      _text = string.gsub( _text, "ü", "\195\188" );
                      _text = string.gsub( _text, "ß", "\195\159" );
                      _text = string.gsub( _text, "Ä", "\195\132" );
                      _text = string.gsub( _text, "Ö", "\195\150" );
                      _text = string.gsub( _text, "Ü", "\195\156" );
                      return _text;
                  elseif texttype == "table" then
                      for k, v in _text do
                          _text[k] = Umlaute( v );
                      end
                      return _text;
                  else return _text;
                  end
              end;
end
function Briefing_SetParameter(_standard, _time, _zoomdistance, _zoomangle, _dialog_zoomdistance, _dialog_zoomangle)
    if _standard == true then
        BRIEFING_TIMER_PER_CHAR = 1.2
        BRIEFING_ZOOMDISTANCE = 4400
        BRIEFING_ZOOMANGLE = 35
        DIALOG_ZOOMDISTANCE = 2800
        DIALOG_ZOOMANGLE =25
    else
        BRIEFING_TIMER_PER_CHAR = _time
        BRIEFING_ZOOMDISTANCE = _zoomdistance
        BRIEFING_ZOOMANGLE = _zoomangle
        DIALOG_ZOOMDISTANCE = _dialog_zoomdistance
        DIALOG_ZOOMANGLE =_dialog_zoomangle    
    end
end
function AddPages( _briefing )
    local AP = function(_page) table.insert(_briefing, _page); return _page; end
    local ASP = function(_entity, _title, _text, _dialog, _explore) return AP(CreateShortPage(_entity, _title, _text, _dialog, _explore)); end
    return AP, ASP;
end
function CreateShortPage( _entity, _title, _text, _dialog, _explore) 
    local page = {
        title = _title,
        text = _text,
        position = GetPosition( _entity ),
        action = function ()Display.SetRenderFogOfWar(0) end
    };
    if _dialog then 
            if type(_dialog) == "boolean" then
                  page.dialogCamera = true; 
            elseif type(_dialog) == "number" then
                  page.explore = _dialog;
            end
      end
    if _explore then 
            if type(_explore) == "boolean" then
                  page.dialogCamera = true; 
            elseif type(_explore) == "number" then
                  page.explore = _explore;
            end
      end      
    return page;
end
function AddPages( _briefing )
	local AP = function(_page) table.insert(_briefing, _page) return _page end
	local ASP = function(_entity, _title, _text, _dialog, _explore)
		return AP(CreateShortPage(_entity, _title, _text, _dialog, _explore)) end
	return AP, ASP
end

function CreateShortPage( _entity, _title, _text, _dialog, _explore) 
	local page = {
		title = _title,
		text = _text,
		position = GetPosition( _entity ),
		action = function() Display.SetRenderFogOfWar(0) end
	}
	if _dialog then 
		if type(_dialog) == "boolean" then
			page.dialogCamera = true 
		elseif type(_dialog) == "number" then
			page.explore = _dialog
		end
	end
	if _explore then 
		if type(_explore) == "boolean" then
			page.dialogCamera = true 
		elseif type(_explore) == "number" then
			page.explore = _explore
		end
	end
	return page
end

---------------------------------------------------------------------------------------------------
--#############################################################################################
function StartCountdown(_Limit, _Callback, _Show)
    assert(type(_Limit) == "number")
    assert( not _Callback or type(_Callback) == "function" )
    Counter.Index = (Counter.Index or 0) + 1
    if _Show and CountdownIsVisisble() then
        _Show=false --ein weiterer kann nicht angezeigt werden
		--assert(false, "StartCountdown: A countdown is already visible")
    end
    Counter["counter" .. Counter.Index] = {Limit = _Limit, TickCount = 0, Callback = _Callback, Show = _Show, Finished = false}
    if _Show then
        MapLocal_StartCountDown(_Limit)
    end
    if Counter.JobId == nil then
        Counter.JobId = StartSimpleJob("CountdownTick")
    end
    return Counter.Index
end

function StopCountdown(_Id)
    if Counter.Index == nil then
        return
    end
    if _Id == nil then
        for i = 1, Counter.Index do
            if Counter.IsValid("counter" .. i) then
                if Counter["counter" .. i].Show then
                    MapLocal_StopCountDown()
                end
                Counter["counter" .. i] = nil
            end
        end
    else
        if Counter.IsValid("counter" .. _Id) then
            if Counter["counter" .. _Id].Show then
                MapLocal_StopCountDown()
            end
            Counter["counter" .. _Id] = nil
        end
    end
end
function CountdownTick()
    local empty = true
    for i = 1, Counter.Index do
        if Counter.IsValid("counter" .. i) then
            if Counter.Tick("counter" .. i) then
                Counter["counter" .. i].Finished = true
            end
            if Counter["counter" .. i].Finished and not IsBriefingActive() then
                if Counter["counter" .. i].Show then
                    MapLocal_StopCountDown()
                end
                -- callback function
                if type(Counter["counter" .. i].Callback) == "function" then
                    Counter["counter" .. i].Callback()
                end
                Counter["counter" .. i] = nil
            end
            empty = false
        end
    end
    if empty then
        Counter.JobId = nil
        Counter.Index = nil
        return true
    end
end
function CountdownIsVisisble()
    for i = 1, Counter.Index do
        if Counter.IsValid("counter" .. i) and Counter["counter" .. i].Show then
            return true
        end
    end
    return false
end
function ActivateShareExploration(_player1, _player2, _both)
    assert(type(_player1) == "number" and type(_player2) == "number" and _player1 <= 8 and _player2 <= 8 and _player1 >= 1 and _player2 >= 1)
    if _both == false then
        Logic.SetShareExplorationWithPlayerFlag(_player1, _player2, 1)
    else
        Logic.SetShareExplorationWithPlayerFlag(_player1, _player2, 1)
        Logic.SetShareExplorationWithPlayerFlag(_player2, _player1, 1)
    end
end
function ReplaceEntity(_Entity, _EntityType)
	local entityId      = GetID(_Entity)
	local pos 			= GetPosition(_Entity)
	local name 			= Logic.GetEntityName(entityId)
	local player 		= Logic.EntityGetPlayer(entityId)
	local orientation 	= Logic.GetEntityOrientation(entityId)
	local wasSelected	= IsEntitySelected(_Entity)
	if wasSelected then
		GUI.DeselectEntity(entityId)
    	end
	DestroyEntity(_Entity)
	local newEntityId = Logic.CreateEntity(_EntityType,pos.X,pos.Y,orientation,player)
	Logic.SetEntityName(newEntityId, name)
	if wasSelected then
		GUI.SelectEntity(newEntityId)
    	end
	GroupSelection_EntityIDChanged(entityId, newEntityId)
	return newEntityId
end

-- Quest data
MapEditor_QuestTitle				= ""
MapEditor_QuestDescription 	= ""